/*
 * Globalize Culture fr-FR
 *
 * http://github.com/jquery/globalize
 *
 * Copyright Software Freedom Conservancy, Inc.
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * This file was generated by the Globalize Culture Generator
 * Translation: bugs found in this file need to be fixed in the generator
 */

(function( window, undefined ) {

var Globalize;

if ( typeof require !== "undefined" &&
	typeof exports !== "undefined" &&
	typeof module !== "undefined" ) {
	// Assume CommonJS
	Globalize = require( "globalize" );
} else {
	// Global variable
	Globalize = window.Globalize;
}

Globalize.addCultureInfo( "fr-FR", "default", {
	name: "fr-FR",
	englishName: "French (France)",
	nativeName: "français (France)",
	language: "fr",
	numberFormat: {
		",": " ",
		".": ",",
		"NaN": "Non Numérique",
		negativeInfinity: "-Infini",
		positiveInfinity: "+Infini",
		percent: {
			",": " ",
			".": ","
		},
		currency: {
			pattern: ["-n $","n $"],
			",": " ",
			".": ",",
			symbol: "€"
		}
	},
	calendars: {
		standard: {
			firstDay: 1,
			days: {
				names: ["dimanche","lundi","mardi","mercredi","jeudi","vendredi","samedi"],
				namesAbbr: ["dim.","lun.","mar.","mer.","jeu.","ven.","sam."],
				namesShort: ["di","lu","ma","me","je","ve","sa"]
			},
			months: {
				names: ["janvier","février","mars","avril","mai","juin","juillet","août","septembre","octobre","novembre","décembre",""],
				namesAbbr: ["janv.","févr.","mars","avr.","mai","juin","juil.","août","sept.","oct.","nov.","déc.",""]
			},
			AM: null,
			PM: null,
			eras: [{"name":"ap. J.-C.","start":null,"offset":0}],
			patterns: {
				d: "dd/MM/yyyy",
				D: "dddd d MMMM yyyy",
				t: "HH:mm",
				T: "HH:mm:ss",
				f: "dddd d MMMM yyyy HH:mm",
				F: "dddd d MMMM yyyy HH:mm:ss",
				M: "d MMMM",
				Y: "MMMM yyyy"
			}
		}
	}
});

}( this ));
(function() {
var merge = function(obj1, obj2) {
  var obj3 = {};
  for(var attrname in obj1){obj3[attrname] = obj1[attrname]; }
  for(var attrname in obj2){obj3[attrname] = obj2[attrname]; }
  return obj3;
}
var dict = {
  "box user": "Utilisateur",
  "filetype_box user": "Utilisateur",
  "html": "Fichier HTML",
  "filetype_html": "Fichier HTML",
  "wiki": "Wiki",
  "filetype_wiki": "Wiki",
  "webscraperwebpage": "Page Web",
  "filetype_webscraperwebpage": "Page Web",
  "image": "Image",
  "filetype_image": "Image",
  "folder": "Dossier",
  "filetype_folder": "Dossier",
  "txt": "Texte",
  "filetype_txt": "Texte",
  "zip": "Fichier Zip",
  "filetype_zip": "Fichier Zip",
  "olefile": "Fichier OLE",
  "filetype_olefile": "Fichier OLE",
  "gmailmessage": "Message Gmail",
  "filetype_gmailmessage": "Message Gmail",
  "pdf": "Fichier PDF",
  "filetype_pdf": "Fichier PDF",
  "swf": "Fichier Flash",
  "filetype_swf": "Fichier Flash",
  "xml": "Fichier XML",
  "filetype_xml": "Fichier XML",
  "vsd": "Visio",
  "filetype_vsd": "Visio",
  "svg": "SVG",
  "filetype_svg": "SVG",
  "svm": "Open Office",
  "filetype_svm": "Open Office",
  "rssitem": "Flux RSS",
  "filetype_rssitem": "Flux RSS",
  "doc": "Document",
  "filetype_doc": "Document",
  "docx": "Document Microsoft Word",
  "filetype_docx": "Document Microsoft Word",
  "xls": "Feuille de calcul",
  "filetype_xls": "Feuille de calcul",
  "ppt": "Présentation",
  "filetype_ppt": "Présentation",
  "video": "Vidéo",
  "filetype_video": "Vidéo",
  "youtube": "Vidéos YouTube",
  "filetype_youtube": "Vidéos YouTube",
  "saleforceitem": "Salesforce",
  "filetype_saleforceitem": "Salesforce",
  "dynamicscrmitem": "Dynamics CRM",
  "filetype_dynamicscrmitem": "Dynamics CRM",
  "salesforceitem": "Salesforce",
  "filetype_salesforceitem": "Salesforce",
  "odt": "Document Open Text",
  "filetype_odt": "Document Open Text",
  "box": "Utilisateur",
  "filetype_box": "Utilisateur",
  "jiraissue": "Issue Jira",
  "filetype_jiraissue": "Issue Jira",
  "cfpage": "Page Confluence",
  "filetype_cfpage": "Page Confluence",
  "cfcomment": "Commentaire Confluence",
  "filetype_cfcomment": "Commentaire Confluence",
  "cfspace": "Espace Confluence",
  "filetype_cfspace": "Espace Confluence",
  "cfblogentry": "Blogue Confluence",
  "filetype_cfblogentry": "Blogue Confluence",
  "confluencespace": "Espace Confluence",
  "filetype_confluencespace": "Espace Confluence",
  "exchangemessage": "Message",
  "filetype_exchangemessage": "Message",
  "exchangeappointment": "Rendez-vous",
  "filetype_exchangeappointment": "Rendez-vous",
  "exchangenote": "Note",
  "filetype_exchangenote": "Note",
  "exchangetask": "Tâche",
  "filetype_exchangetask": "Tâche",
  "exchangeperson": "Utilisateur Exchange",
  "filetype_exchangeperson": "Utilisateur Exchange",
  "activedirperson": "Utilisateur Active Directory",
  "filetype_activedirperson": "Utilisateur Active Directory",
  "exchangeactivity": "Activité",
  "filetype_exchangeactivity": "Activité",
  "exchangecalendarmessage": "Message de calendrier",
  "filetype_exchangecalendarmessage": "Message de calendrier",
  "exchangedocument": "Document Exchange",
  "filetype_exchangedocument": "Document Exchange",
  "exchangedsn": "DSN",
  "filetype_exchangedsn": "DSN",
  "exchangefreebusy": "Disponibilité",
  "filetype_exchangefreebusy": "Disponibilité",
  "exchangegroup": "Groupe",
  "filetype_exchangegroup": "Groupe",
  "exchangerssfeed": "Flux RSS",
  "filetype_exchangerssfeed": "Flux RSS",
  "exchangejunkmessage": "Courrier indésirable",
  "filetype_exchangejunkmessage": "Courrier indésirable",
  "exchangeofficecom": "Communications",
  "filetype_exchangeofficecom": "Communications",
  "lithiummessage": "Message Lithium",
  "filetype_lithiummessage": "Message Lithium",
  "lithiumthread": "Fil de conversation Lithium",
  "filetype_lithiumthread": "Fil de conversation Lithium",
  "lithiumboard": "Babillard électronique Lithium",
  "filetype_lithiumboard": "Babillard électronique Lithium",
  "lithiumcategory": "Catégorie Lithium",
  "filetype_lithiumcategory": "Catégorie Lithium",
  "lithiumcommunity": "Communauté Lithium",
  "filetype_lithiumcommunity": "Communauté Lithium",
  "people": "Utilisateur",
  "objecttype_people": "Utilisateur",
  "message": "Message",
  "objecttype_message": "Message",
  "feed": "Flux RSS",
  "objecttype_feed": "Flux RSS",
  "thread": "Fil de conversation",
  "objecttype_thread": "Fil de conversation",
  "file": "Fichier",
  "objecttype_file": "Fichier",
  "board": "Tableau",
  "objecttype_board": "Tableau",
  "category": "Catégorie",
  "objecttype_category": "Catégorie",
  "account": "Compte",
  "objecttype_account": "Compte",
  "annotation": "Note",
  "objecttype_annotation": "Note",
  "campaign": "Campagne",
  "objecttype_campaign": "Campagne",
  "case": "Cas",
  "objecttype_case": "Cas",
  "contact": "Contact",
  "objecttype_contact": "Contact",
  "contract": "Contrat",
  "objecttype_contract": "Contrat",
  "event": "Événement",
  "objecttype_event": "Événement",
  "email": "Email",
  "objecttype_email": "Email",
  "goal": "Objectif",
  "objecttype_goal": "Objectif",
  "incident": "Incident",
  "objecttype_incident": "Incident",
  "invoice": "Facture",
  "objecttype_invoice": "Facture",
  "lead": "Lead",
  "objecttype_lead": "Lead",
  "list": "Liste",
  "objecttype_list": "Liste marketing",
  "solution": "Solution",
  "objecttype_solution": "Solution",
  "report": "Rapport",
  "objecttype_report": "Rapport",
  "task": "Tâche",
  "objecttype_task": "Tâche",
  "user": "Utilisateur",
  "objecttype_user": "Utilisateur",
  "attachment": "Pièce jointe",
  "objecttype_attachment": "Pièce jointe",
  "casecomment": "Commentaire sur un cas",
  "objecttype_casecomment": "Commentaire sur un cas",
  "opportunity": "Opportunité",
  "objecttype_opportunity": "Opportunité",
  "opportunityproduct": "Produit d'opportunité",
  "objecttype_opportunityproduct": "Produit d'opportunité",
  "feeditem": "Chatter",
  "objecttype_feeditem": "Chatter",
  "feedcomment": "Commentaire",
  "objecttype_feedcomment": "Commentaire",
  "note": "Note",
  "objecttype_note": "Note",
  "product": "Produit",
  "objecttype_product": "Produit",
  "partner": "Partenaire",
  "objecttype_partner": "Partenaire",
  "queueitem": "Élément de file d'attente",
  "objecttype_queueitem": "Élément de file d'attente",
  "quote": "Devis",
  "objecttype_quote": "Devis",
  "salesliterature": "Documentation commerciale",
  "objecttype_salesliterature": "Documentation commerciale",
  "salesorder": "Commande",
  "objecttype_salesorder": "Commande",
  "service": "Service",
  "objecttype_service": "Service",
  "socialprofile": "Profil social",
  "objecttype_socialprofile": "Profil social",
  "kbdocumentation": "Article de Documentation",
  "objecttype_kbdocumentation": "Article de Documentation",
  "kbtechnicalarticle": "Documentation Technique",
  "objecttype_kbtechnicalarticle": "Documentation Technique",
  "kbsolution": "Solution",
  "objecttype_kbsolution": "Solution",
  "kbknowledgearticle": "Article de base de connaissance",
  "objecttype_kbknowledgearticle": "Article de base de connaissance",
  "kbattachment": "Pièce jointe",
  "objecttype_kbattachment": "Pièce jointe",
  "kbarticle": "Article",
  "objecttype_kbarticle": "Article",
  "kbarticlecomment": "Commentaire d'article",
  "objecttype_kbarticlecomment": "Commentaire d'article",
  "knowledgearticle": "Article de base de connaissance",
  "objecttype_knowledgearticle": "Article de base de connaissance",
  "topic": "Sujet",
  "objecttype_topic": "Sujet",
  "dashboard": "Tableau de bord",
  "objecttype_dashboard": "Tableau de bord",
  "contentversion": "Document",
  "objecttype_contentversion": "Document",
  "collaborationgroup": "Groupe de collaboration",
  "objecttype_collaborationgroup": "Groupe de collaboration",
  "phonecall": "Appel téléphonique",
  "objecttype_phonecall": "Appel téléphonique",
  "appointment": "Rendez vous",
  "objecttype_appointment": "Rendez vous",
  "sn_hr_core_case": "Requête RH",
  "filetype_sn_hr_core_case": "Requête RH",
  "sc_cat_item": "Item du Catalogue",
  "filetype_sc_cat_item": "Item du Catalogue",
  "sn_customerservice_case": "Requête",
  "filetype_sn_customerservice_case": "Requête",
  "kb_social_qa_answer": "Réponse",
  "filetype_kb_social_qa_answer": "Réponse",
  "kb_social_qa_question": "Question",
  "filetype_kb_social_qa_question": "Question",
  "kb_social_qa_comment": "Commentaire",
  "filetype_kb_social_qa_comment": "Commentaire",
  "filetype_incident": "Incident",
  "kb_knowledge": "Article",
  "filetype_kb_knowledge": "Article",
  "spportal": "Portail",
  "filetype_spportal": "Portail",
  "spsite": "Site SharePoint",
  "filetype_spsite": "Site SharePoint",
  "spuserprofile": "Utilisateur SharePoint",
  "filetype_spuserprofile": "Utilisateur SharePoint",
  "sparea": "Zone",
  "filetype_sparea": "Zone",
  "spannouncement": "Annonce",
  "filetype_spannouncement": "Annonce",
  "spannouncementlist": "Annonces",
  "filetype_spannouncementlist": "Annonces",
  "spcontact": "Contact",
  "filetype_spcontact": "Contact",
  "spcontactlist": "Contacts",
  "filetype_spcontactlist": "Contacts",
  "spcustomlist": "Listes personnalisées",
  "filetype_spcustomlist": "Listes personnalisées",
  "spdiscussionboard": "Forum de discussion",
  "filetype_spdiscussionboard": "Forum de discussion",
  "spdiscussionboardlist": "Forums de discussion",
  "filetype_spdiscussionboardlist": "Forums de discussion",
  "spdocumentlibrarylist": "Bibliothèque de documents",
  "filetype_spdocumentlibrarylist": "Bibliothèque de documents",
  "spevent": "Événement",
  "filetype_spevent": "Événement",
  "speventlist": "Événements",
  "filetype_speventlist": "Événements",
  "spformlibrarylist": "Bibliothèque de formulaires",
  "filetype_spformlibrarylist": "Bibliothèque de formulaires",
  "spissue": "Problème",
  "filetype_spissue": "Problème",
  "spissuelist": "Problèmes",
  "filetype_spissuelist": "Problèmes",
  "splink": "Lien",
  "filetype_splink": "Lien",
  "splinklist": "Liens",
  "filetype_splinklist": "Liens",
  "sppicturelibrarylist": "Bibliothèque d'images",
  "filetype_sppicturelibrarylist": "Bibliothèque d'images",
  "spsurvey": "Enquête",
  "filetype_spsurvey": "Enquête",
  "spsurveylist": "Enquêtes",
  "filetype_spsurveylist": "Enquêtes",
  "sptask": "Tâche",
  "filetype_sptask": "Tâche",
  "sptasklist": "Tâches",
  "filetype_sptasklist": "Tâches",
  "spagenda": "Ordre du jour",
  "filetype_spagenda": "Ordre du jour",
  "spagendalist": "Ordres du jour",
  "filetype_spagendalist": "Ordres du jour",
  "spattendee": "Participant",
  "filetype_spattendee": "Participant",
  "spattendeelist": "Participants",
  "filetype_spattendeelist": "Participants",
  "spcustomgridlist": "Grilles personnalisées",
  "filetype_spcustomgridlist": "Grilles personnalisées",
  "spdecision": "Décision",
  "filetype_spdecision": "Décision",
  "spdecisionlist": "Décisions",
  "filetype_spdecisionlist": "Décisions",
  "spobjective": "Objectif",
  "filetype_spobjective": "Objectif",
  "spobjectivelist": "Objectifs",
  "filetype_spobjectivelist": "Objectifs",
  "sptextbox": "Zone de texte",
  "filetype_sptextbox": "Zone de texte",
  "sptextboxlist": "Liste de zones de texte",
  "filetype_sptextboxlist": "Liste de zones de texte",
  "spthingstobring": "Élément à prévoir",
  "filetype_spthingstobring": "Élément à prévoir",
  "spthingstobringlist": "Éléments à prévoir",
  "filetype_spthingstobringlist": "Éléments à prévoir",
  "sparealisting": "Listing de zone",
  "filetype_sparealisting": "Listing de zone",
  "spmeetingserie": "Série de réunions",
  "filetype_spmeetingserie": "Série de réunions",
  "spmeetingserielist": "Liste de séries de réunions",
  "filetype_spmeetingserielist": "Liste de séries de réunions",
  "spsitedirectory": "Élément d'un annuaire de sites",
  "filetype_spsitedirectory": "Élément d'un annuaire de sites",
  "spsitedirectorylist": "Annuaire de sites",
  "filetype_spsitedirectorylist": "Annuaire de sites",
  "spdatasource": "Source de données",
  "filetype_spdatasource": "Source de données",
  "spdatasourcelist": "Liste de sources de données",
  "filetype_spdatasourcelist": "Liste de sources de données",
  "splisttemplatecataloglist": "Galerie Modèles de listes",
  "filetype_splisttemplatecataloglist": "Galerie Modèles de listes",
  "spwebpartcataloglist": "Galerie Composants WebPart",
  "filetype_spwebpartcataloglist": "Galerie Composants WebPart",
  "spwebtemplatecataloglist": "Galerie Modèles de sites",
  "filetype_spwebtemplatecataloglist": "Galerie Modèles de sites",
  "spworkspacepagelist": "Pages d'espace de travail",
  "filetype_spworkspacepagelist": "Pages d'espace de travail",
  "spunknownlist": "Liste personnalisée",
  "filetype_spunknownlist": "Liste personnalisée",
  "spadministratortask": "Tâche d'administration",
  "filetype_spadministratortask": "Tâche d'administration",
  "spadministratortasklist": "Tâches d'administration",
  "filetype_spadministratortasklist": "Tâches d'administration",
  "spareadocumentlibrarylist": "Bibliothèque de documents de zone",
  "filetype_spareadocumentlibrarylist": "Bibliothèque de documents de zone",
  "spblogcategory": "Catégorie de blogue",
  "filetype_spblogcategory": "Catégorie de blogue",
  "spblogcategorylist": "Catégories de blogue",
  "filetype_spblogcategorylist": "Catégories de blogue",
  "spblogcomment": "Commentaire de blogue",
  "filetype_spblogcomment": "Commentaire de blogue",
  "spblogcommentlist": "Commentaires de blogue",
  "filetype_spblogcommentlist": "Commentaires de blogue",
  "spblogpost": "Article de blogue",
  "filetype_spblogpost": "Article de blogue",
  "spblogpostlist": "Articles de blogue",
  "filetype_spblogpostlist": "Articles de blogue",
  "spdataconnectionlibrarylist": "Bibliothèque de connexions de données",
  "filetype_spdataconnectionlibrarylist": "Bibliothèque de connexions de données",
  "spdistributiongroup": "Groupe de distribution",
  "filetype_spdistributiongroup": "Groupe de distribution",
  "spdistributiongrouplist": "Groupes de distribution",
  "filetype_spdistributiongrouplist": "Groupes de distribution",
  "spipfslist": "Serveurs de formulaires InfoPath",
  "filetype_spipfslist": "Serveurs de formulaires InfoPath",
  "spkeyperformanceindicator": "Indicateur de performance clé",
  "filetype_spkeyperformanceindicator": "Indicateur de performance clé",
  "spkeyperformanceindicatorlist": "Indicateurs de performance clé",
  "filetype_spkeyperformanceindicatorlist": "Indicateurs de performance clé",
  "splanguagesandtranslator": "Langues et traducteur",
  "filetype_splanguagesandtranslator": "Langues et traducteur",
  "splanguagesandtranslatorlist": "Langues et traducteurs",
  "filetype_splanguagesandtranslatorlist": "Langues et traducteurs",
  "spmasterpagescataloglist": "Galerie Pages maîtres",
  "filetype_spmasterpagescataloglist": "Galerie Pages maîtres",
  "spnocodeworkflowlibrarylist": "Bibliothèques de flux de travail sans code",
  "filetype_spnocodeworkflowlibrarylist": "Bibliothèques de flux de travail sans code",
  "spprojecttask": "Tâche de projet",
  "filetype_spprojecttask": "Tâche de projet",
  "spprojecttasklist": "Tâches de projet",
  "filetype_spprojecttasklist": "Tâches de projet",
  "sppublishingpageslibrarylist": "Bibliothèque de pages",
  "filetype_sppublishingpageslibrarylist": "Bibliothèque de pages",
  "spreportdocumentlibrarylist": "Bibliothèque de documents de rapport",
  "filetype_spreportdocumentlibrarylist": "Bibliothèque de documents de rapport",
  "spreportlibrarylist": "Bibliothèque de rapports",
  "filetype_spreportlibrarylist": "Bibliothèque de rapports",
  "spslidelibrarylist": "Bibliothèque de diapositives",
  "filetype_spslidelibrarylist": "Bibliothèque de diapositives",
  "sptab": "Onglets",
  "filetype_sptab": "Onglets",
  "sptablist": "Liste d'onglets",
  "filetype_sptablist": "Liste d'onglets",
  "sptranslationmanagementlibrarylist": "Bibliothèque Gestion des traductions",
  "filetype_sptranslationmanagementlibrarylist": "Bibliothèque Gestion des traductions",
  "spuserinformation": "Information utilisateur",
  "filetype_spuserinformation": "Information utilisateur",
  "spuserinformationlist": "Liste d'informations utilisateur",
  "filetype_spuserinformationlist": "Liste d'informations utilisateur",
  "spwikipagelibrarylist": "Bibliothèque de pages Wiki",
  "filetype_spwikipagelibrarylist": "Bibliothèque de pages Wiki",
  "spworkflowhistory": "Historique de flux de travail",
  "filetype_spworkflowhistory": "Historique de flux de travail",
  "spworkflowhistorylist": "Liste d'historiques de flux de travail",
  "filetype_spworkflowhistorylist": "Liste d'historiques de flux de travail",
  "spworkflowprocess": "Processus de flux de travail personnalisé",
  "filetype_spworkflowprocess": "Processus de flux de travail personnalisé",
  "spworkflowprocesslist": "Liste de processus de flux de travail personnalisés",
  "filetype_spworkflowprocesslist": "Liste de processus de flux de travail personnalisés",
  "sppublishingimageslibrarylist": "Bibliothèque d'images de publication",
  "filetype_sppublishingimageslibrarylist": "Bibliothèque d'images de publication",
  "spcirculation": "Circulation",
  "filetype_spcirculation": "Circulation",
  "spcirculationlist": "Circulations",
  "filetype_spcirculationlist": "Circulations",
  "spdashboardslibrarylist": "Bibliothèque de tableaux de bord",
  "filetype_spdashboardslibrarylist": "Bibliothèque de tableaux de bord",
  "spdataconnectionforperformancepointlibrarylist": "Bibliothèque de connexions de données PerformancePoint",
  "filetype_spdataconnectionforperformancepointlibrarylist": "Bibliothèque de connexions de données PerformancePoint",
  "sphealthreport": "Rapport d'intégrité",
  "filetype_sphealthreport": "Rapport d'intégrité",
  "sphealthreportlist": "Rapports d'intégrité",
  "filetype_sphealthreportlist": "Rapports d'intégrité",
  "sphealthrule": "Règle d'intégrité",
  "filetype_sphealthrule": "Règle d'intégrité",
  "sphealthrulelist": "Règles d'intégrité",
  "filetype_sphealthrulelist": "Règles d'intégrité",
  "spimedictionary": "Dictionnaire IME",
  "filetype_spimedictionary": "Dictionnaire IME",
  "spimedictionarylist": "Dictionnaires IME",
  "filetype_spimedictionarylist": "Dictionnaires IME",
  "spperformancepointcontent": "Contenu PerformancePoint",
  "filetype_spperformancepointcontent": "Contenu PerformancePoint",
  "spperformancepointcontentlist": "Contenus PerformancePoint",
  "filetype_spperformancepointcontentlist": "Contenus PerformancePoint",
  "spphonecallmemo": "Mémo d'appel téléphonique",
  "filetype_spphonecallmemo": "Mémo d'appel téléphonique",
  "spphonecallmemolist": "Mémos d'appels téléphoniques",
  "filetype_spphonecallmemolist": "Mémos d'appels téléphoniques",
  "sprecordlibrarylist": "Bibliothèque d'enregistrements",
  "filetype_sprecordlibrarylist": "Bibliothèque d'enregistrements",
  "spresource": "Ressource",
  "filetype_spresource": "Ressource",
  "spresourcelist": "Ressources",
  "filetype_spresourcelist": "Ressources",
  "spprocessdiagramslibrarylist": "Bibliothèque de diagrammes de processus",
  "filetype_spprocessdiagramslibrarylist": "Bibliothèque de diagrammes de processus",
  "spsitethemeslibrarylist": "Bibliothèque de thèmes de site",
  "filetype_spsitethemeslibrarylist": "Bibliothèque de thèmes de site",
  "spsolutionslibrarylist": "Bibliothèque de solutions",
  "filetype_spsolutionslibrarylist": "Bibliothèque de solutions",
  "spwfpublibrarylist": "Bibliothèque de WFPUB",
  "filetype_spwfpublibrarylist": "Bibliothèque de WFPUB",
  "spwhereabout": "Localisation",
  "filetype_spwhereabout": "Localisation",
  "spwhereaboutlist": "Localisations",
  "filetype_spwhereaboutlist": "Localisations",
  "spdocumentlink": "Lien vers un document",
  "filetype_spdocumentlink": "Lien vers un document",
  "spdocumentset": "Ensemble de documents",
  "filetype_spdocumentset": "Ensemble de documents",
  "spmicrofeedpost": "Publication d'un microflux",
  "filetype_spmicrofeedpost": "Publication d'un microflux",
  "spmicrofeedlist": "Microflux",
  "filetype_spmicrofeedlist": "Microflux",
  "splistfolder": "Dossier de liste",
  "filetype_splistfolder": "Dossier de liste",
  "slackmessage": "Message Slack",
  "filetype_slackmessage": "Message Slack",
  "slackchannel": "Canal Slack",
  "filetype_slackchannel": "Canal Slack",
  "slackfile": "Fichier Slack",
  "filetype_slackfile": "Fichier Slack",
  "slackuser": "Utilisateur Slack",
  "filetype_slackuser": "Utilisateur Slack",
  "youtubevideo": "Vidéos YouTube",
  "filetype_youtubevideo": "Vidéos YouTube",
  "youtubeplaylistitem": "Élément de liste de lecture",
  "filetype_youtubeplaylistitem": "Élément de liste de lecture",
  "youtubeplaylist": "Liste de lecture",
  "filetype_youtubeplaylist": "Liste de lecture",
  "Unknown": "Inconnu",
  "And": "ET",
  "Authenticating": "Authentification à {0} en cours...",
  "Clear": "Effacer {0}",
  "CompleteQuery": "Requête complète",
  "Exclude": "Exclure {0}",
  "EnterTag": "Ajouter un Tag",
  "Next": "Suivant",
  "Last": "Précédent",
  "Link": "Lien",
  "Or": "OU",
  "Previous": "Précédent",
  "QueryDidntMatchAnyDocuments": "Votre requête n'a retourné aucun document.",
  "QueryException": "Votre requête a une erreur : {0}.",
  "Me": "Moi",
  "Remove": "Enlever",
  "Search": "Recherche",
  "SearchFor": "Recherche pour {0}",
  "SubmitSearch": "Envoyer la requête",
  "ShareQuery": "Partager cette requête",
  "Preferences": "Préférences",
  "LinkOpeningSettings": "Réglage pour l'ouverture des liens",
  "Reauthenticate": "Réauthentifier {0}",
  "ResultsFilteringExpression": "Expressions de filtrage des résultats",
  "FiltersInYourPreferences": "Filtres dans vos préférences",
  "Create": "Créer",
  "SearchIn": "Rechercher dans {0}",
  "Seconds": "en {0} seconde<pl>s</pl>",
  "ShowingResultsOf": "Résultat<pl>s</pl> {0}<pl>-{1}</pl> de {2}",
  "ShowingResultsOfWithQuery": "Résultat<pl>s</pl> {0}<pl>-{1}</pl> de {2} pour {3}",
  "SwitchTo": "Basculer vers {0}",
  "Unexclude": "Enlever le filtre d'exclusion sur {0}",
  "ClearAllFilters": "Enlever tous les filtres",
  "SkipLogin": "Passer la connexion",
  "LoginInProgress": "Connexion en cours, veuillez patienter...",
  "Login": "Connexion",
  "GetStarted": "Démarrer",
  "More": "Plus",
  "NMore": "{0} de plus...",
  "Less": "Moins",
  "Settings": "Réglages",
  "Score": "Score",
  "ScoreDescription": "Le score est calculé en fonction du nombre d'occurences et de sa position dans les résultats.",
  "Occurrences": "Occurrences",
  "OccurrencesDescription": "Trier selon l'occurrence, avec les valeurs les plus élevées apparaissant en premier.",
  "Label": "Étiquette",
  "Of": "de",
  "LabelDescription": "Trier alphabétiquement sur la valeur des champs.",
  "Value": "Valeur",
  "ValueDescription": "Trier sur les valeurs du premier champ calculé",
  "AlphaAscending": "Valeur croissante",
  "AlphaDescending": "Valeur Décroissante",
  "ChiSquare": "Chi Square",
  "Nosort": "Aucun tri",
  "NosortDescription": "Ne pas trier les valeurs. Les valeurs seront retournées dans un ordre aléatoire",
  "RelativeFrequency": "Fréquence relative",
  "RelativeFrequencyDescription": "Trier sur la fréquence relative des valeurs. Les valeurs moins fréquentes vont apparaîtrent plus haute.",
  "DateDistribution": "Date de distribution relative",
  "Custom": "Personnalisé",
  "CustomDescription": "Trier de manière personalisée",
  "ComputedField": "Champ calculé",
  "Ascending": "Croissant",
  "Descending": "Décroissant",
  "noResultFor": "Aucun résultat pour {0}",
  "noResult": "Aucun résultat",
  "autoCorrectedQueryTo": "La requête a été corrigée automatiquement à {0}",
  "didYouMean": "Vouliez-vous dire : {0}",
  "SuggestedResults": "Résultats suggérés",
  "SuggestedQueries": "Requêtes suggérées",
  "MostRelevantItems": "Items les plus pertinents :",
  "AllItems": "Tous les items :",
  "ShowLess": "Voir moins de résultats",
  "ShowMore": "Voir plus de résultats",
  "HideFacet": "Cacher la facette",
  "ShowFacet": "Afficher la facette",
  "AndOthers": "et {0}autre<pl>s</pl>",
  "Others": "{0} autre<pl>s</pl>",
  "MostRelevantPosts": "Messages les plus pertinents :",
  "CompleteThread": "Toute la discussion :",
  "ShowCompleteThread": "Voir l'ensemble de la discussion",
  "ShowOnlyTopMatchingPosts": "Voir seulement les messages les plus pertinents",
  "MostRelevantReplies": "Réponses les plus pertinentes :",
  "AllConversation": "Toute la conversation :",
  "ShowAllConversation": "Voir l'ensemble de la conversation",
  "ShowAllReplies": "Voir toutes les réponses",
  "ShowOnlyMostRelevantReplies": "Voir seulement les réponses les plus pertinentes",
  "Close": "Fermer",
  "Open": "Ouvrir",
  "OpenInOutlookWhenPossible": "Ouvrir dans Outlook (quand c'est possible)",
  "AlwaysOpenInNewWindow": "Toujours ouvrir les résultats dans une nouvelle fenêtre",
  "Quickview": "Coup D'Oeil",
  "NoQuickview": "Le Coup D'Oeil pour ce document n'est pas disponible",
  "ErrorReport": "Rapport d'erreur",
  "OopsError": "Une erreur s'est produite.",
  "ProblemPersists": "Si le problème persiste, contactez l'administrateur.",
  "GoBack": "Retour en arrière",
  "Reset": "Réinitialiser",
  "Retry": "Réessayer",
  "MoreInfo": "Plus d'information",
  "Username": "Nom d'utilisateur",
  "Password": "Mot de passe",
  "PostedBy": "Écrit par",
  "CannotConnect": "Impossible de se connecter au serveur.",
  "BadUserPass": "Mauvaise combinaison de nom d'utilisateur et mot de passe.",
  "PleaseEnterYourCredentials": "Veuillez entrer votre nom d'utilisateur et mot de passe pour {0}.",
  "PleaseEnterYourSearchPage": "Veuillez entrer votre URL de page de recherche",
  "Collapse": "Réduire",
  "Collapsable": "Refermable",
  "Expand": "Agrandir",
  "CollapseFacet": "Réduire la facette {0}",
  "ExpandFacet": "Agrandir la facette {0}",
  "ShowLessFacetResults": "Afficher moins de résultats pour la facette {0}",
  "ShowMoreFacetResults": "Afficher plus de résultats pour la facette {0}",
  "ShowLessCategoryResults": "Afficher moins de résultats pour la catégorie {0}",
  "ShowMoreCategoryResults": "Afficher plus de résultats pour la catégorie {0}",
  "SearchFacetResults": "Rechercher des valeurs dans la facette {0}",
  "Today": "Aujourd'hui",
  "Yesterday": "Hier",
  "Tomorrow": "Demain",
  "Duration": "Durée : {0}",
  "IndexDuration": "Durée Index : {0}",
  "ProxyDuration": "Durée Proxy: {0}",
  "ClientDuration": "Durée Client: {0}",
  "Unavailable": "Non disponible",
  "Reply": "Répondre",
  "ReplyAll": "Répondre à tous",
  "Forward": "Transférer",
  "From": "De",
  "Caption": "Légende",
  "Expression": "Expression",
  "Tab": "Onglet",
  "Tabs": "Onglets",
  "EnterExpressionName": "Entrez le nom de l'expression",
  "EnterExpressionToFilterWith": "Entrez l'expression pour filtrer les résultats",
  "SelectTab": "Selectionnez l'onglet",
  "SelectAll": "Sélectionnez tout",
  "PageUrl": "URL de la page de recherche",
  "ErrorSavingToDevice": "Erreur lors de l'écriture sur votre appareil",
  "ErrorReadingFromDevice": "Erreur lors de la lecture de l'information sur votre appareil",
  "AppIntro": "Contactez-nous pour parler avec un spécialiste de produit qui pourra répondre à vos questions a propos de Coveo. Ou bien, essayer une demonstration !",
  "TryDemo": "Essayer le démo",
  "ContactUs": "Contactez-nous",
  "NewToCoveo": "Qu'est-ce que Coveo?",
  "LetUsHelpGetStarted": "Laisser nous vous aidez a démarrer",
  "LikesThis": "{0} aime<pl>nt</pl> ça.",
  "CannotConnectSearchPage": "Impossible de rejoindre votre page de recherche",
  "AreYouSureDeleteFilter": "Êtes vous sur de vouloir effacer le filtre {0}avec l'expression {1}",
  "OnlineHelp": "Aide en ligne",
  "Done": "Terminé",
  "SaveFacetState": "Sauvegarder l'état de la facette",
  "ClearFacetState": "Effacer l'état de la facette",
  "DisplayingTheOnlyMessage": "Affichage du seul message dans cette conversation",
  "NoNetworkConnection": "Aucune connexion réseau",
  "UnknownConnection": "Connexion inconnue",
  "EthernetConnection": "Connexion Ethernet",
  "WiFi": "Connexion WiFi",
  "CELL": "Connexion cellulaire",
  "CELL_2G": "Connexion cellulaire 2g",
  "CELL_3G": "Connexion cellulaire 3g",
  "CELL_4G": "Connexion cellulaire 4g",
  "Relevance": "Pertinence",
  "Date": "Date",
  "Amount": "Montant",
  "QueryExceptionNoException": "Aucune exception",
  "QueryExceptionInvalidSyntax": "Syntaxe invalide",
  "QueryExceptionInvalidCustomField": "Champ personnalisé invalide",
  "QueryExceptionInvalidDate": "Date invalide",
  "QueryExceptionInvalidExactPhrase": "Phrase exacte invalide",
  "QueryExceptionInvalidDateOp": "Opérateur de date invalide",
  "QueryExceptionInvalidNear": "Fonction de proximité (PRES) invalide",
  "QueryExceptionInvalidWeightedNear": "Pondérée de la fonction de proximité invalide",
  "QueryExceptionInvalidTerm": "Terme invalide",
  "QueryExceptionTooManyTerms": "Trop de termes",
  "QueryExceptionWildcardTooGeneral": "Métacaractère trop général",
  "QueryExceptionInvalidSortField": "Champ de tri invalide",
  "QueryExceptionInvalidSmallStringOp": "Opérateur de petite chaîne invalide",
  "QueryExceptionRequestedResultsMax": "Maximum des résultats demandés",
  "QueryExceptionAggregatedMirrorDead": "Le miroir agrégé est hors-ligne",
  "QueryExceptionAggregatedMirrorQueryTimeOut": "Délai de requête du miroir agrégé dépassé",
  "QueryExceptionAggregatedMirrorInvalidBuildNumber": "Numéro de version du miroir agrégé invalide",
  "QueryExceptionAggregatedMirrorCannotConnect": "Connexion impossible au miroir agrégé",
  "QueryExceptionNotEnoughLeadingCharsWildcard": "Pas assez de caractères en début de chaîne pour le métacaractère",
  "QueryExceptionSecurityInverterNotFound": "Inverseur de sécurité introuvable",
  "QueryExceptionSecurityInverterAccessDenied": "Accès refusé à l'inverseur de sécurité",
  "QueryExceptionAggregatedMirrorCannotImpersonate": "Le miroir agrégé ne peut pas usurper l'identité",
  "QueryExceptionUnexpected": "Inattendu",
  "QueryExceptionAccessDenied": "Accès refusé",
  "QueryExceptionSuperUserTokenInvalid": "Jeton du super-utilisateur invalide",
  "QueryExceptionSuperUserTokenExpired": "Le jeton du super-utilisateur est expiré",
  "QueryExceptionLicenseQueriesExpired": "La licence de requêtes est expirée",
  "QueryExceptionLicenseSuperUserTokenNotSupported": "Licence de jeton de super utilisateur non pris en charge",
  "QueryExceptionInvalidSession": "Session invalide",
  "QueryExceptionInvalidDocument": "Document invalide",
  "QueryExceptionSearchDisabled": "Recherche désactivée",
  "FileType": "Type de fichier",
  "ShowAttachment": "Voir pièce jointe",
  "OnFeed": "sur le fil de {0}.",
  "Author": "Auteur",
  "NoTitle": "Pas de titre",
  "CurrentSelections": "Sélections courantes",
  "AllContent": "Tout le contenu",
  "CancelLastAction": "Annuler la dernière action",
  "SearchTips": "Conseils de recherche",
  "CheckSpelling": "Vérifiez l'orthographe de vos mots-clés.",
  "TryUsingFewerKeywords": "Essayez d'utiliser moins ou différents mots-clés.",
  "SelectFewerFilters": "Sélectionner moins de filtres pour élargir votre recherche.",
  "Document": "Document",
  "Time": "Temps",
  "StartDate": "Date de début",
  "StartTime": "Heure de début",
  "DurationTitle": "Durée",
  "UserQuery": "Requête de l'utilisateur",
  "ShowUserActions": "Afficher les actions de l'utilisateur",
  "NoData": "Aucune donnée disponible",
  "EventType": "Type d'évenement",
  "GoToFullSearch": "Aller à la page de recherche",
  "GoToEdition": "Personnaliser le panneau",
  "RemoveContext": "Enlever le contexte",
  "BoxAttachToCase": "Attacher à la requête",
  "AttachToCase": "Attacher à la requête",
  "Attach": "Attacher",
  "Attached": "Attaché",
  "Detach": "Détacher",
  "Details": "Détails",
  "AdditionalFilters": "Filtres additionnels",
  "SelectNonContextualSearch": "Enlevez le contexte de l'entrée courante pour élargir vos résultats de recherche",
  "CopyPasteToSupport": "Copier-coller ce message à l'équipe de support de Coveo pour plus d'informations.",
  "FollowQueryDescription": "Avertissez-moi lorsque les résultats de recherche de cette requête changent.",
  "SearchAlerts_Panel": "Gérer les alertes",
  "SearchAlerts_PanelDescription": "Afficher et gérer vos alertes de recherche.",
  "SearchAlerts_PanelNoSearchAlerts": "Vous n'avez aucun abonnement.",
  "SearchAlerts_Fail": "Le service d'alertes de recherche n'est actuellement pas disponible.",
  "SearchAlerts_Type": "Type",
  "SearchAlerts_Content": "Contenu",
  "SearchAlerts_Actions": "Action",
  "EmptyQuery": "<vide>",
  "SearchAlerts_Type_followQuery": "Requête",
  "SearchAlerts_Type_followDocument": "Item",
  "SearchAlerts_unFollowing": "Ne plus suivre",
  "SearchAlerts_follow": "Suivre",
  "SearchAlerts_followed": "Suivi",
  "SearchAlerts_followQuery": "Suivre la requête",
  "Subscription_StopFollowingQuery": "Ne plus suivre la requête",
  "SearchAlerts_Frequency": "Quand",
  "SubscriptionsManageSubscriptions": "Gérer vos alertes",
  "SubscriptionsMessageFollowQuery": "Vous recevrez des alertes lorsque la requête <b>{0}</ b> retournera des items nouveaux ou mis à jour.",
  "SubscriptionsMessageFollow": "Vous recevrez des alertes lorsque l'item <b>{0}</b> sera mis à jour.",
  "Expiration": "Expiration",
  "Monthly": "Mensuel",
  "Daily": "Quotidiennement",
  "Monday": "Lundi",
  "Tuesday": "Mardi",
  "Wednesday": "Mercredi",
  "Thursday": "Jeudi",
  "Friday": "Vendredi",
  "Saturday": "Samedi",
  "Sunday": "Dimanche",
  "NextDay": "{0} prochain",
  "LastDay": "{0} dernier",
  "StartTypingCaseForSuggestions": "Décrivez votre problème pour voir des solutions possibles",
  "ExportToExcel": "Exportez en format Excel",
  "ExportToExcelDescription": "Exportez les résultats de recherche en format Excel",
  "CaseCreationNoResults": "Aucune recommandation de solution n'a été trouvée",
  "SortBy": "Trier par",
  "BoxCreateArticle": "Créer un Article",
  "Facets": "Facettes",
  "AdvancedSearch": "Recherche Avancée",
  "Keywords": "Mot-clés",
  "AllTheseWords": "Tous ces mots",
  "ExactPhrase": "Cette phrase exacte",
  "AnyOfTheseWords": "N'importe lequel de ces mots",
  "NoneOfTheseWords": "Aucun de ces mots",
  "Anytime": "N'importe quand",
  "InTheLast": "Dans les derniers",
  "Days": "jours",
  "Months": "mois",
  "Month": "Mois",
  "Year": "Année",
  "Between": "Entre",
  "Language": "Langage",
  "Size": "Taille",
  "AtLeast": "au moins",
  "AtMost": "au plus",
  "Contains": "contient",
  "DoesNotContain": "ne contient pas",
  "Matches": "égale",
  "Bytes": "octets",
  "card": "Carte",
  "table": "Tableau",
  "ResultLinks": "Liens de résultat",
  "EnableQuerySyntax": "Activation de la syntaxe de recherche",
  "On": "Activé",
  "Off": "Désactivé",
  "Automatic": "Automatique",
  "ResultsPerPage": "Résultats par page",
  "PreviousMonth": "Mois précédent",
  "NextMonth": "Mois suivant",
  "Title": "Titre",
  "FiltersInAdvancedSearch": "Filtres pour la Recherche Avancée",
  "NoEndpoints": "{0} n'a pas de point de terminaison unique.",
  "InvalidToken": "Le jeton d'identification est invalide.",
  "AddSources": "Vous devrez ajouter des sources à votre index, ou attendre la fin de l'indexation des sources créées.",
  "TryAgain": "Veuillez essayer de nouveau.",
  "CoveoOnlineHelp": "Aide en ligne Coveo",
  "CannotAccess": "{0} est inaccessible.",
  "CoveoOrganization": "Organisation Coveo",
  "SearchAPIDuration": "Durée de l'API de recherche : {0}",
  "LastUpdated": "Dernière mise à jour",
  "AllDates": "Toutes les dates",
  "WithinLastDay": "Depuis le dernier jour",
  "WithinLastWeek": "Depuis la dernière semaine",
  "WithinLastMonth": "Depuis le dernier mois",
  "WithinLastYear": "Depuis la dernière année",
  "RelevanceInspector": "Inspecteur de Pertinence des Documents",
  "KeywordInCategory": "{0} <span class=\"coveo-omnibox-suggestion-category\">dans {1}</span>",
  "Result": "Résultat",
  "ResultCount": "{0} résultat<pl>s</pl>",
  "ShowingResults": "{0} résultat<pl>s</pl>",
  "ShowingResultsWithQuery": "{0} résultat<pl>s</pl> pour {1}",
  "NumberOfVideos": "Nombre de vidéos",
  "AllCategories": "Toutes les catégories",
  "Recommended": "Recommandé",
  "Featured": "En vedette",
  "CoveoHomePage": "Page d'accueil Coveo",
  "SizeValue": "Valeur de la taille",
  "UnitMeasurement": "Unité de taille",
  "Toggle": "Basculer",
  "FilterOn": "Filtrer sur {0}",
  "RemoveFilterOn": "Enlever le filtre d'inclusion sur {0}",
  "Enter": "Entrée",
  "InsertAQuery": "Insérer une requête",
  "PressEnterToSend": "Appuyez sur Entrée pour envoyer",
  "SortResultsBy": "Trier les résultats par {0}",
  "SortResultsByAscending": "Trier en ordre croissant de {0}",
  "SortResultsByDescending": "Trier en ordre décroissant de {0}",
  "DisplayResultsAs": "Afficher les résultats comme {0}",
  "FacetTitle": "Facette {0}",
  "IncludeValueWithResultCount": "Filtre d'inclusion sur {0}; {1}",
  "ExcludeValueWithResultCount": "Filtre d'exclusion sur {0}; {1}",
  "PageNumber": "Page {0}",
  "DisplayResultsPerPage": "Afficher {0} résultats par page",
  "GroupByAndFacetRequestsCannotCoexist": "La requête n'est pas valide car elle contient les requêtes Group By et Facet. Assurez-vous que l'interface de recherche n'initialise pas les composants DynamicFacet aux côtés des composants Facet (ou de tout composant d'extension du composant Facet, tel que FacetRange ou FacetSlider).",
  "MustContain": "Doit contenir:",
  "Missing": "Manquant(s):",
  "Filters": "Filtres",
  "FiltersDropdown": "Menu déroulant de filtres",
  "OpenFiltersDropdown": "Ouvrir le menu déroulant de filtres",
  "CloseFiltersDropdown": "Fermer le menu déroulant de filtres",
  "NoValuesFound": "Aucune valeur trouvée.",
  "To": "à",
  "DeselectFilterValues": "Effacer tout de filtres actifs dans {0}",
  "Rated": "Évalué {0} sur {1} étoile<pl>s<pl/>",
  "RatedBy": "par {0} utilisateur<pl>s</pl>",
  "NoRatings": "Aucune évaluation",
  "Pagination": "Pagination",
  "ThumbnailOf": "Aperçu de « {0} »",
  "CollapsedUriParts": "Segments d'URI réduits",
  "HierarchicalFacetValueIndentedUnder": "{0} sous {1}",
  "HierarchicalFacetValuePathPrefix": "dans",
  "UsefulnessFeedbackRequest": "Était-ce utile?",
  "UsefulnessFeedbackThankYou": "Merci pour votre rétroaction!",
  "UsefulnessFeedbackExplainWhy": "Expliquer pourquoi",
  "UsefulnessFeedbackExplainWhyImperative": "Expliquez pourquoi",
  "UsefulnessFeedbackDoesNotAnswer": "Ceci n'a pas répondu à ma question du tout",
  "UsefulnessFeedbackPartiallyAnswers": "Ceci a seulement partiellement répondu à ma question",
  "UsefulnessFeedbackWasNotAQuestion": "Ma requête n'était pas sensée être perçue comme une question",
  "Yes": "Oui",
  "No": "Non",
  "Other": "Autre",
  "Send": "Envoyer",
  "Edit": "Éditer",
  "Delete": "Supprimer",
  "Save": "Sauvegarder",
  "UsefulnessFeedbackReason": "Raison",
  "AnswerSnippet": "Réponse à votre question",
  "AnswerSpecificSnippet": "Réponse à « {0} »",
  "SuggestedQuestions": "Autres questions posées",
  "ExpandQuestionAnswer": "Regarder la réponse à « {0} »",
  "MoreValuesAvailable": "des valeurs additionnelles sont disponibles",
  "Breadcrumb": "Filtres actifs",
  "OrganizationIsPaused": "Votre organisation Coveo est en pause pour cause d'inactivité et la recherche est présentement non disponible.",
  "OrganizationWillResume": "Votre organisation redeviendra active et sera bientôt disponible.",
  "UpdatingResults": "Chargement des résultats",
  "QuerySuggestionsAvailable": "{0} suggestion<pl>s</pl> de recherche disponible.",
  "QuerySuggestionsUnavailable": "Il n'y a pas de suggestions de recherche.",
}
  var locales = String["locales"] || (String["locales"] = {});
  locales["fr"] = merge(locales["fr"], dict);
  String["toLocaleString"].call(this, { "fr": dict });
  String["locale"] = "fr";
  String["defaultLocale"] = "en";
  Globalize.culture("fr")})();
if(!window.Coveo){window.Coveo = {};}
Coveo.setLanguageAfterPageLoaded = function() {
var merge = function(obj1, obj2) {
  var obj3 = {};
  for(var attrname in obj1){obj3[attrname] = obj1[attrname]; }
  for(var attrname in obj2){obj3[attrname] = obj2[attrname]; }
  return obj3;
}

var dict = {
  "box user": "Utilisateur",
  "filetype_box user": "Utilisateur",
  "html": "Fichier HTML",
  "filetype_html": "Fichier HTML",
  "wiki": "Wiki",
  "filetype_wiki": "Wiki",
  "webscraperwebpage": "Page Web",
  "filetype_webscraperwebpage": "Page Web",
  "image": "Image",
  "filetype_image": "Image",
  "folder": "Dossier",
  "filetype_folder": "Dossier",
  "txt": "Texte",
  "filetype_txt": "Texte",
  "zip": "Fichier Zip",
  "filetype_zip": "Fichier Zip",
  "olefile": "Fichier OLE",
  "filetype_olefile": "Fichier OLE",
  "gmailmessage": "Message Gmail",
  "filetype_gmailmessage": "Message Gmail",
  "pdf": "Fichier PDF",
  "filetype_pdf": "Fichier PDF",
  "swf": "Fichier Flash",
  "filetype_swf": "Fichier Flash",
  "xml": "Fichier XML",
  "filetype_xml": "Fichier XML",
  "vsd": "Visio",
  "filetype_vsd": "Visio",
  "svg": "SVG",
  "filetype_svg": "SVG",
  "svm": "Open Office",
  "filetype_svm": "Open Office",
  "rssitem": "Flux RSS",
  "filetype_rssitem": "Flux RSS",
  "doc": "Document",
  "filetype_doc": "Document",
  "docx": "Document Microsoft Word",
  "filetype_docx": "Document Microsoft Word",
  "xls": "Feuille de calcul",
  "filetype_xls": "Feuille de calcul",
  "ppt": "Présentation",
  "filetype_ppt": "Présentation",
  "video": "Vidéo",
  "filetype_video": "Vidéo",
  "youtube": "Vidéos YouTube",
  "filetype_youtube": "Vidéos YouTube",
  "saleforceitem": "Salesforce",
  "filetype_saleforceitem": "Salesforce",
  "dynamicscrmitem": "Dynamics CRM",
  "filetype_dynamicscrmitem": "Dynamics CRM",
  "salesforceitem": "Salesforce",
  "filetype_salesforceitem": "Salesforce",
  "odt": "Document Open Text",
  "filetype_odt": "Document Open Text",
  "box": "Utilisateur",
  "filetype_box": "Utilisateur",
  "jiraissue": "Issue Jira",
  "filetype_jiraissue": "Issue Jira",
  "cfpage": "Page Confluence",
  "filetype_cfpage": "Page Confluence",
  "cfcomment": "Commentaire Confluence",
  "filetype_cfcomment": "Commentaire Confluence",
  "cfspace": "Espace Confluence",
  "filetype_cfspace": "Espace Confluence",
  "cfblogentry": "Blogue Confluence",
  "filetype_cfblogentry": "Blogue Confluence",
  "confluencespace": "Espace Confluence",
  "filetype_confluencespace": "Espace Confluence",
  "exchangemessage": "Message",
  "filetype_exchangemessage": "Message",
  "exchangeappointment": "Rendez-vous",
  "filetype_exchangeappointment": "Rendez-vous",
  "exchangenote": "Note",
  "filetype_exchangenote": "Note",
  "exchangetask": "Tâche",
  "filetype_exchangetask": "Tâche",
  "exchangeperson": "Utilisateur Exchange",
  "filetype_exchangeperson": "Utilisateur Exchange",
  "activedirperson": "Utilisateur Active Directory",
  "filetype_activedirperson": "Utilisateur Active Directory",
  "exchangeactivity": "Activité",
  "filetype_exchangeactivity": "Activité",
  "exchangecalendarmessage": "Message de calendrier",
  "filetype_exchangecalendarmessage": "Message de calendrier",
  "exchangedocument": "Document Exchange",
  "filetype_exchangedocument": "Document Exchange",
  "exchangedsn": "DSN",
  "filetype_exchangedsn": "DSN",
  "exchangefreebusy": "Disponibilité",
  "filetype_exchangefreebusy": "Disponibilité",
  "exchangegroup": "Groupe",
  "filetype_exchangegroup": "Groupe",
  "exchangerssfeed": "Flux RSS",
  "filetype_exchangerssfeed": "Flux RSS",
  "exchangejunkmessage": "Courrier indésirable",
  "filetype_exchangejunkmessage": "Courrier indésirable",
  "exchangeofficecom": "Communications",
  "filetype_exchangeofficecom": "Communications",
  "lithiummessage": "Message Lithium",
  "filetype_lithiummessage": "Message Lithium",
  "lithiumthread": "Fil de conversation Lithium",
  "filetype_lithiumthread": "Fil de conversation Lithium",
  "lithiumboard": "Babillard électronique Lithium",
  "filetype_lithiumboard": "Babillard électronique Lithium",
  "lithiumcategory": "Catégorie Lithium",
  "filetype_lithiumcategory": "Catégorie Lithium",
  "lithiumcommunity": "Communauté Lithium",
  "filetype_lithiumcommunity": "Communauté Lithium",
  "people": "Utilisateur",
  "objecttype_people": "Utilisateur",
  "message": "Message",
  "objecttype_message": "Message",
  "feed": "Flux RSS",
  "objecttype_feed": "Flux RSS",
  "thread": "Fil de conversation",
  "objecttype_thread": "Fil de conversation",
  "file": "Fichier",
  "objecttype_file": "Fichier",
  "board": "Tableau",
  "objecttype_board": "Tableau",
  "category": "Catégorie",
  "objecttype_category": "Catégorie",
  "account": "Compte",
  "objecttype_account": "Compte",
  "annotation": "Note",
  "objecttype_annotation": "Note",
  "campaign": "Campagne",
  "objecttype_campaign": "Campagne",
  "case": "Cas",
  "objecttype_case": "Cas",
  "contact": "Contact",
  "objecttype_contact": "Contact",
  "contract": "Contrat",
  "objecttype_contract": "Contrat",
  "event": "Événement",
  "objecttype_event": "Événement",
  "email": "Email",
  "objecttype_email": "Email",
  "goal": "Objectif",
  "objecttype_goal": "Objectif",
  "incident": "Incident",
  "objecttype_incident": "Incident",
  "invoice": "Facture",
  "objecttype_invoice": "Facture",
  "lead": "Lead",
  "objecttype_lead": "Lead",
  "list": "Liste",
  "objecttype_list": "Liste marketing",
  "solution": "Solution",
  "objecttype_solution": "Solution",
  "report": "Rapport",
  "objecttype_report": "Rapport",
  "task": "Tâche",
  "objecttype_task": "Tâche",
  "user": "Utilisateur",
  "objecttype_user": "Utilisateur",
  "attachment": "Pièce jointe",
  "objecttype_attachment": "Pièce jointe",
  "casecomment": "Commentaire sur un cas",
  "objecttype_casecomment": "Commentaire sur un cas",
  "opportunity": "Opportunité",
  "objecttype_opportunity": "Opportunité",
  "opportunityproduct": "Produit d'opportunité",
  "objecttype_opportunityproduct": "Produit d'opportunité",
  "feeditem": "Chatter",
  "objecttype_feeditem": "Chatter",
  "feedcomment": "Commentaire",
  "objecttype_feedcomment": "Commentaire",
  "note": "Note",
  "objecttype_note": "Note",
  "product": "Produit",
  "objecttype_product": "Produit",
  "partner": "Partenaire",
  "objecttype_partner": "Partenaire",
  "queueitem": "Élément de file d'attente",
  "objecttype_queueitem": "Élément de file d'attente",
  "quote": "Devis",
  "objecttype_quote": "Devis",
  "salesliterature": "Documentation commerciale",
  "objecttype_salesliterature": "Documentation commerciale",
  "salesorder": "Commande",
  "objecttype_salesorder": "Commande",
  "service": "Service",
  "objecttype_service": "Service",
  "socialprofile": "Profil social",
  "objecttype_socialprofile": "Profil social",
  "kbdocumentation": "Article de Documentation",
  "objecttype_kbdocumentation": "Article de Documentation",
  "kbtechnicalarticle": "Documentation Technique",
  "objecttype_kbtechnicalarticle": "Documentation Technique",
  "kbsolution": "Solution",
  "objecttype_kbsolution": "Solution",
  "kbknowledgearticle": "Article de base de connaissance",
  "objecttype_kbknowledgearticle": "Article de base de connaissance",
  "kbattachment": "Pièce jointe",
  "objecttype_kbattachment": "Pièce jointe",
  "kbarticle": "Article",
  "objecttype_kbarticle": "Article",
  "kbarticlecomment": "Commentaire d'article",
  "objecttype_kbarticlecomment": "Commentaire d'article",
  "knowledgearticle": "Article de base de connaissance",
  "objecttype_knowledgearticle": "Article de base de connaissance",
  "topic": "Sujet",
  "objecttype_topic": "Sujet",
  "dashboard": "Tableau de bord",
  "objecttype_dashboard": "Tableau de bord",
  "contentversion": "Document",
  "objecttype_contentversion": "Document",
  "collaborationgroup": "Groupe de collaboration",
  "objecttype_collaborationgroup": "Groupe de collaboration",
  "phonecall": "Appel téléphonique",
  "objecttype_phonecall": "Appel téléphonique",
  "appointment": "Rendez vous",
  "objecttype_appointment": "Rendez vous",
  "sn_hr_core_case": "Requête RH",
  "filetype_sn_hr_core_case": "Requête RH",
  "sc_cat_item": "Item du Catalogue",
  "filetype_sc_cat_item": "Item du Catalogue",
  "sn_customerservice_case": "Requête",
  "filetype_sn_customerservice_case": "Requête",
  "kb_social_qa_answer": "Réponse",
  "filetype_kb_social_qa_answer": "Réponse",
  "kb_social_qa_question": "Question",
  "filetype_kb_social_qa_question": "Question",
  "kb_social_qa_comment": "Commentaire",
  "filetype_kb_social_qa_comment": "Commentaire",
  "filetype_incident": "Incident",
  "kb_knowledge": "Article",
  "filetype_kb_knowledge": "Article",
  "spportal": "Portail",
  "filetype_spportal": "Portail",
  "spsite": "Site SharePoint",
  "filetype_spsite": "Site SharePoint",
  "spuserprofile": "Utilisateur SharePoint",
  "filetype_spuserprofile": "Utilisateur SharePoint",
  "sparea": "Zone",
  "filetype_sparea": "Zone",
  "spannouncement": "Annonce",
  "filetype_spannouncement": "Annonce",
  "spannouncementlist": "Annonces",
  "filetype_spannouncementlist": "Annonces",
  "spcontact": "Contact",
  "filetype_spcontact": "Contact",
  "spcontactlist": "Contacts",
  "filetype_spcontactlist": "Contacts",
  "spcustomlist": "Listes personnalisées",
  "filetype_spcustomlist": "Listes personnalisées",
  "spdiscussionboard": "Forum de discussion",
  "filetype_spdiscussionboard": "Forum de discussion",
  "spdiscussionboardlist": "Forums de discussion",
  "filetype_spdiscussionboardlist": "Forums de discussion",
  "spdocumentlibrarylist": "Bibliothèque de documents",
  "filetype_spdocumentlibrarylist": "Bibliothèque de documents",
  "spevent": "Événement",
  "filetype_spevent": "Événement",
  "speventlist": "Événements",
  "filetype_speventlist": "Événements",
  "spformlibrarylist": "Bibliothèque de formulaires",
  "filetype_spformlibrarylist": "Bibliothèque de formulaires",
  "spissue": "Problème",
  "filetype_spissue": "Problème",
  "spissuelist": "Problèmes",
  "filetype_spissuelist": "Problèmes",
  "splink": "Lien",
  "filetype_splink": "Lien",
  "splinklist": "Liens",
  "filetype_splinklist": "Liens",
  "sppicturelibrarylist": "Bibliothèque d'images",
  "filetype_sppicturelibrarylist": "Bibliothèque d'images",
  "spsurvey": "Enquête",
  "filetype_spsurvey": "Enquête",
  "spsurveylist": "Enquêtes",
  "filetype_spsurveylist": "Enquêtes",
  "sptask": "Tâche",
  "filetype_sptask": "Tâche",
  "sptasklist": "Tâches",
  "filetype_sptasklist": "Tâches",
  "spagenda": "Ordre du jour",
  "filetype_spagenda": "Ordre du jour",
  "spagendalist": "Ordres du jour",
  "filetype_spagendalist": "Ordres du jour",
  "spattendee": "Participant",
  "filetype_spattendee": "Participant",
  "spattendeelist": "Participants",
  "filetype_spattendeelist": "Participants",
  "spcustomgridlist": "Grilles personnalisées",
  "filetype_spcustomgridlist": "Grilles personnalisées",
  "spdecision": "Décision",
  "filetype_spdecision": "Décision",
  "spdecisionlist": "Décisions",
  "filetype_spdecisionlist": "Décisions",
  "spobjective": "Objectif",
  "filetype_spobjective": "Objectif",
  "spobjectivelist": "Objectifs",
  "filetype_spobjectivelist": "Objectifs",
  "sptextbox": "Zone de texte",
  "filetype_sptextbox": "Zone de texte",
  "sptextboxlist": "Liste de zones de texte",
  "filetype_sptextboxlist": "Liste de zones de texte",
  "spthingstobring": "Élément à prévoir",
  "filetype_spthingstobring": "Élément à prévoir",
  "spthingstobringlist": "Éléments à prévoir",
  "filetype_spthingstobringlist": "Éléments à prévoir",
  "sparealisting": "Listing de zone",
  "filetype_sparealisting": "Listing de zone",
  "spmeetingserie": "Série de réunions",
  "filetype_spmeetingserie": "Série de réunions",
  "spmeetingserielist": "Liste de séries de réunions",
  "filetype_spmeetingserielist": "Liste de séries de réunions",
  "spsitedirectory": "Élément d'un annuaire de sites",
  "filetype_spsitedirectory": "Élément d'un annuaire de sites",
  "spsitedirectorylist": "Annuaire de sites",
  "filetype_spsitedirectorylist": "Annuaire de sites",
  "spdatasource": "Source de données",
  "filetype_spdatasource": "Source de données",
  "spdatasourcelist": "Liste de sources de données",
  "filetype_spdatasourcelist": "Liste de sources de données",
  "splisttemplatecataloglist": "Galerie Modèles de listes",
  "filetype_splisttemplatecataloglist": "Galerie Modèles de listes",
  "spwebpartcataloglist": "Galerie Composants WebPart",
  "filetype_spwebpartcataloglist": "Galerie Composants WebPart",
  "spwebtemplatecataloglist": "Galerie Modèles de sites",
  "filetype_spwebtemplatecataloglist": "Galerie Modèles de sites",
  "spworkspacepagelist": "Pages d'espace de travail",
  "filetype_spworkspacepagelist": "Pages d'espace de travail",
  "spunknownlist": "Liste personnalisée",
  "filetype_spunknownlist": "Liste personnalisée",
  "spadministratortask": "Tâche d'administration",
  "filetype_spadministratortask": "Tâche d'administration",
  "spadministratortasklist": "Tâches d'administration",
  "filetype_spadministratortasklist": "Tâches d'administration",
  "spareadocumentlibrarylist": "Bibliothèque de documents de zone",
  "filetype_spareadocumentlibrarylist": "Bibliothèque de documents de zone",
  "spblogcategory": "Catégorie de blogue",
  "filetype_spblogcategory": "Catégorie de blogue",
  "spblogcategorylist": "Catégories de blogue",
  "filetype_spblogcategorylist": "Catégories de blogue",
  "spblogcomment": "Commentaire de blogue",
  "filetype_spblogcomment": "Commentaire de blogue",
  "spblogcommentlist": "Commentaires de blogue",
  "filetype_spblogcommentlist": "Commentaires de blogue",
  "spblogpost": "Article de blogue",
  "filetype_spblogpost": "Article de blogue",
  "spblogpostlist": "Articles de blogue",
  "filetype_spblogpostlist": "Articles de blogue",
  "spdataconnectionlibrarylist": "Bibliothèque de connexions de données",
  "filetype_spdataconnectionlibrarylist": "Bibliothèque de connexions de données",
  "spdistributiongroup": "Groupe de distribution",
  "filetype_spdistributiongroup": "Groupe de distribution",
  "spdistributiongrouplist": "Groupes de distribution",
  "filetype_spdistributiongrouplist": "Groupes de distribution",
  "spipfslist": "Serveurs de formulaires InfoPath",
  "filetype_spipfslist": "Serveurs de formulaires InfoPath",
  "spkeyperformanceindicator": "Indicateur de performance clé",
  "filetype_spkeyperformanceindicator": "Indicateur de performance clé",
  "spkeyperformanceindicatorlist": "Indicateurs de performance clé",
  "filetype_spkeyperformanceindicatorlist": "Indicateurs de performance clé",
  "splanguagesandtranslator": "Langues et traducteur",
  "filetype_splanguagesandtranslator": "Langues et traducteur",
  "splanguagesandtranslatorlist": "Langues et traducteurs",
  "filetype_splanguagesandtranslatorlist": "Langues et traducteurs",
  "spmasterpagescataloglist": "Galerie Pages maîtres",
  "filetype_spmasterpagescataloglist": "Galerie Pages maîtres",
  "spnocodeworkflowlibrarylist": "Bibliothèques de flux de travail sans code",
  "filetype_spnocodeworkflowlibrarylist": "Bibliothèques de flux de travail sans code",
  "spprojecttask": "Tâche de projet",
  "filetype_spprojecttask": "Tâche de projet",
  "spprojecttasklist": "Tâches de projet",
  "filetype_spprojecttasklist": "Tâches de projet",
  "sppublishingpageslibrarylist": "Bibliothèque de pages",
  "filetype_sppublishingpageslibrarylist": "Bibliothèque de pages",
  "spreportdocumentlibrarylist": "Bibliothèque de documents de rapport",
  "filetype_spreportdocumentlibrarylist": "Bibliothèque de documents de rapport",
  "spreportlibrarylist": "Bibliothèque de rapports",
  "filetype_spreportlibrarylist": "Bibliothèque de rapports",
  "spslidelibrarylist": "Bibliothèque de diapositives",
  "filetype_spslidelibrarylist": "Bibliothèque de diapositives",
  "sptab": "Onglets",
  "filetype_sptab": "Onglets",
  "sptablist": "Liste d'onglets",
  "filetype_sptablist": "Liste d'onglets",
  "sptranslationmanagementlibrarylist": "Bibliothèque Gestion des traductions",
  "filetype_sptranslationmanagementlibrarylist": "Bibliothèque Gestion des traductions",
  "spuserinformation": "Information utilisateur",
  "filetype_spuserinformation": "Information utilisateur",
  "spuserinformationlist": "Liste d'informations utilisateur",
  "filetype_spuserinformationlist": "Liste d'informations utilisateur",
  "spwikipagelibrarylist": "Bibliothèque de pages Wiki",
  "filetype_spwikipagelibrarylist": "Bibliothèque de pages Wiki",
  "spworkflowhistory": "Historique de flux de travail",
  "filetype_spworkflowhistory": "Historique de flux de travail",
  "spworkflowhistorylist": "Liste d'historiques de flux de travail",
  "filetype_spworkflowhistorylist": "Liste d'historiques de flux de travail",
  "spworkflowprocess": "Processus de flux de travail personnalisé",
  "filetype_spworkflowprocess": "Processus de flux de travail personnalisé",
  "spworkflowprocesslist": "Liste de processus de flux de travail personnalisés",
  "filetype_spworkflowprocesslist": "Liste de processus de flux de travail personnalisés",
  "sppublishingimageslibrarylist": "Bibliothèque d'images de publication",
  "filetype_sppublishingimageslibrarylist": "Bibliothèque d'images de publication",
  "spcirculation": "Circulation",
  "filetype_spcirculation": "Circulation",
  "spcirculationlist": "Circulations",
  "filetype_spcirculationlist": "Circulations",
  "spdashboardslibrarylist": "Bibliothèque de tableaux de bord",
  "filetype_spdashboardslibrarylist": "Bibliothèque de tableaux de bord",
  "spdataconnectionforperformancepointlibrarylist": "Bibliothèque de connexions de données PerformancePoint",
  "filetype_spdataconnectionforperformancepointlibrarylist": "Bibliothèque de connexions de données PerformancePoint",
  "sphealthreport": "Rapport d'intégrité",
  "filetype_sphealthreport": "Rapport d'intégrité",
  "sphealthreportlist": "Rapports d'intégrité",
  "filetype_sphealthreportlist": "Rapports d'intégrité",
  "sphealthrule": "Règle d'intégrité",
  "filetype_sphealthrule": "Règle d'intégrité",
  "sphealthrulelist": "Règles d'intégrité",
  "filetype_sphealthrulelist": "Règles d'intégrité",
  "spimedictionary": "Dictionnaire IME",
  "filetype_spimedictionary": "Dictionnaire IME",
  "spimedictionarylist": "Dictionnaires IME",
  "filetype_spimedictionarylist": "Dictionnaires IME",
  "spperformancepointcontent": "Contenu PerformancePoint",
  "filetype_spperformancepointcontent": "Contenu PerformancePoint",
  "spperformancepointcontentlist": "Contenus PerformancePoint",
  "filetype_spperformancepointcontentlist": "Contenus PerformancePoint",
  "spphonecallmemo": "Mémo d'appel téléphonique",
  "filetype_spphonecallmemo": "Mémo d'appel téléphonique",
  "spphonecallmemolist": "Mémos d'appels téléphoniques",
  "filetype_spphonecallmemolist": "Mémos d'appels téléphoniques",
  "sprecordlibrarylist": "Bibliothèque d'enregistrements",
  "filetype_sprecordlibrarylist": "Bibliothèque d'enregistrements",
  "spresource": "Ressource",
  "filetype_spresource": "Ressource",
  "spresourcelist": "Ressources",
  "filetype_spresourcelist": "Ressources",
  "spprocessdiagramslibrarylist": "Bibliothèque de diagrammes de processus",
  "filetype_spprocessdiagramslibrarylist": "Bibliothèque de diagrammes de processus",
  "spsitethemeslibrarylist": "Bibliothèque de thèmes de site",
  "filetype_spsitethemeslibrarylist": "Bibliothèque de thèmes de site",
  "spsolutionslibrarylist": "Bibliothèque de solutions",
  "filetype_spsolutionslibrarylist": "Bibliothèque de solutions",
  "spwfpublibrarylist": "Bibliothèque de WFPUB",
  "filetype_spwfpublibrarylist": "Bibliothèque de WFPUB",
  "spwhereabout": "Localisation",
  "filetype_spwhereabout": "Localisation",
  "spwhereaboutlist": "Localisations",
  "filetype_spwhereaboutlist": "Localisations",
  "spdocumentlink": "Lien vers un document",
  "filetype_spdocumentlink": "Lien vers un document",
  "spdocumentset": "Ensemble de documents",
  "filetype_spdocumentset": "Ensemble de documents",
  "spmicrofeedpost": "Publication d'un microflux",
  "filetype_spmicrofeedpost": "Publication d'un microflux",
  "spmicrofeedlist": "Microflux",
  "filetype_spmicrofeedlist": "Microflux",
  "splistfolder": "Dossier de liste",
  "filetype_splistfolder": "Dossier de liste",
  "slackmessage": "Message Slack",
  "filetype_slackmessage": "Message Slack",
  "slackchannel": "Canal Slack",
  "filetype_slackchannel": "Canal Slack",
  "slackfile": "Fichier Slack",
  "filetype_slackfile": "Fichier Slack",
  "slackuser": "Utilisateur Slack",
  "filetype_slackuser": "Utilisateur Slack",
  "youtubevideo": "Vidéos YouTube",
  "filetype_youtubevideo": "Vidéos YouTube",
  "youtubeplaylistitem": "Élément de liste de lecture",
  "filetype_youtubeplaylistitem": "Élément de liste de lecture",
  "youtubeplaylist": "Liste de lecture",
  "filetype_youtubeplaylist": "Liste de lecture",
  "Unknown": "Inconnu",
  "And": "ET",
  "Authenticating": "Authentification à {0} en cours...",
  "Clear": "Effacer {0}",
  "CompleteQuery": "Requête complète",
  "Exclude": "Exclure {0}",
  "EnterTag": "Ajouter un Tag",
  "Next": "Suivant",
  "Last": "Précédent",
  "Link": "Lien",
  "Or": "OU",
  "Previous": "Précédent",
  "QueryDidntMatchAnyDocuments": "Votre requête n'a retourné aucun document.",
  "QueryException": "Votre requête a une erreur : {0}.",
  "Me": "Moi",
  "Remove": "Enlever",
  "Search": "Recherche",
  "SearchFor": "Recherche pour {0}",
  "SubmitSearch": "Envoyer la requête",
  "ShareQuery": "Partager cette requête",
  "Preferences": "Préférences",
  "LinkOpeningSettings": "Réglage pour l'ouverture des liens",
  "Reauthenticate": "Réauthentifier {0}",
  "ResultsFilteringExpression": "Expressions de filtrage des résultats",
  "FiltersInYourPreferences": "Filtres dans vos préférences",
  "Create": "Créer",
  "SearchIn": "Rechercher dans {0}",
  "Seconds": "en {0} seconde<pl>s</pl>",
  "ShowingResultsOf": "Résultat<pl>s</pl> {0}<pl>-{1}</pl> de {2}",
  "ShowingResultsOfWithQuery": "Résultat<pl>s</pl> {0}<pl>-{1}</pl> de {2} pour {3}",
  "SwitchTo": "Basculer vers {0}",
  "Unexclude": "Enlever le filtre d'exclusion sur {0}",
  "ClearAllFilters": "Enlever tous les filtres",
  "SkipLogin": "Passer la connexion",
  "LoginInProgress": "Connexion en cours, veuillez patienter...",
  "Login": "Connexion",
  "GetStarted": "Démarrer",
  "More": "Plus",
  "NMore": "{0} de plus...",
  "Less": "Moins",
  "Settings": "Réglages",
  "Score": "Score",
  "ScoreDescription": "Le score est calculé en fonction du nombre d'occurences et de sa position dans les résultats.",
  "Occurrences": "Occurrences",
  "OccurrencesDescription": "Trier selon l'occurrence, avec les valeurs les plus élevées apparaissant en premier.",
  "Label": "Étiquette",
  "Of": "de",
  "LabelDescription": "Trier alphabétiquement sur la valeur des champs.",
  "Value": "Valeur",
  "ValueDescription": "Trier sur les valeurs du premier champ calculé",
  "AlphaAscending": "Valeur croissante",
  "AlphaDescending": "Valeur Décroissante",
  "ChiSquare": "Chi Square",
  "Nosort": "Aucun tri",
  "NosortDescription": "Ne pas trier les valeurs. Les valeurs seront retournées dans un ordre aléatoire",
  "RelativeFrequency": "Fréquence relative",
  "RelativeFrequencyDescription": "Trier sur la fréquence relative des valeurs. Les valeurs moins fréquentes vont apparaîtrent plus haute.",
  "DateDistribution": "Date de distribution relative",
  "Custom": "Personnalisé",
  "CustomDescription": "Trier de manière personalisée",
  "ComputedField": "Champ calculé",
  "Ascending": "Croissant",
  "Descending": "Décroissant",
  "noResultFor": "Aucun résultat pour {0}",
  "noResult": "Aucun résultat",
  "autoCorrectedQueryTo": "La requête a été corrigée automatiquement à {0}",
  "didYouMean": "Vouliez-vous dire : {0}",
  "SuggestedResults": "Résultats suggérés",
  "SuggestedQueries": "Requêtes suggérées",
  "MostRelevantItems": "Items les plus pertinents :",
  "AllItems": "Tous les items :",
  "ShowLess": "Voir moins de résultats",
  "ShowMore": "Voir plus de résultats",
  "HideFacet": "Cacher la facette",
  "ShowFacet": "Afficher la facette",
  "AndOthers": "et {0}autre<pl>s</pl>",
  "Others": "{0} autre<pl>s</pl>",
  "MostRelevantPosts": "Messages les plus pertinents :",
  "CompleteThread": "Toute la discussion :",
  "ShowCompleteThread": "Voir l'ensemble de la discussion",
  "ShowOnlyTopMatchingPosts": "Voir seulement les messages les plus pertinents",
  "MostRelevantReplies": "Réponses les plus pertinentes :",
  "AllConversation": "Toute la conversation :",
  "ShowAllConversation": "Voir l'ensemble de la conversation",
  "ShowAllReplies": "Voir toutes les réponses",
  "ShowOnlyMostRelevantReplies": "Voir seulement les réponses les plus pertinentes",
  "Close": "Fermer",
  "Open": "Ouvrir",
  "OpenInOutlookWhenPossible": "Ouvrir dans Outlook (quand c'est possible)",
  "AlwaysOpenInNewWindow": "Toujours ouvrir les résultats dans une nouvelle fenêtre",
  "Quickview": "Coup D'Oeil",
  "NoQuickview": "Le Coup D'Oeil pour ce document n'est pas disponible",
  "ErrorReport": "Rapport d'erreur",
  "OopsError": "Une erreur s'est produite.",
  "ProblemPersists": "Si le problème persiste, contactez l'administrateur.",
  "GoBack": "Retour en arrière",
  "Reset": "Réinitialiser",
  "Retry": "Réessayer",
  "MoreInfo": "Plus d'information",
  "Username": "Nom d'utilisateur",
  "Password": "Mot de passe",
  "PostedBy": "Écrit par",
  "CannotConnect": "Impossible de se connecter au serveur.",
  "BadUserPass": "Mauvaise combinaison de nom d'utilisateur et mot de passe.",
  "PleaseEnterYourCredentials": "Veuillez entrer votre nom d'utilisateur et mot de passe pour {0}.",
  "PleaseEnterYourSearchPage": "Veuillez entrer votre URL de page de recherche",
  "Collapse": "Réduire",
  "Collapsable": "Refermable",
  "Expand": "Agrandir",
  "CollapseFacet": "Réduire la facette {0}",
  "ExpandFacet": "Agrandir la facette {0}",
  "ShowLessFacetResults": "Afficher moins de résultats pour la facette {0}",
  "ShowMoreFacetResults": "Afficher plus de résultats pour la facette {0}",
  "ShowLessCategoryResults": "Afficher moins de résultats pour la catégorie {0}",
  "ShowMoreCategoryResults": "Afficher plus de résultats pour la catégorie {0}",
  "SearchFacetResults": "Rechercher des valeurs dans la facette {0}",
  "Today": "Aujourd'hui",
  "Yesterday": "Hier",
  "Tomorrow": "Demain",
  "Duration": "Durée : {0}",
  "IndexDuration": "Durée Index : {0}",
  "ProxyDuration": "Durée Proxy: {0}",
  "ClientDuration": "Durée Client: {0}",
  "Unavailable": "Non disponible",
  "Reply": "Répondre",
  "ReplyAll": "Répondre à tous",
  "Forward": "Transférer",
  "From": "De",
  "Caption": "Légende",
  "Expression": "Expression",
  "Tab": "Onglet",
  "Tabs": "Onglets",
  "EnterExpressionName": "Entrez le nom de l'expression",
  "EnterExpressionToFilterWith": "Entrez l'expression pour filtrer les résultats",
  "SelectTab": "Selectionnez l'onglet",
  "SelectAll": "Sélectionnez tout",
  "PageUrl": "URL de la page de recherche",
  "ErrorSavingToDevice": "Erreur lors de l'écriture sur votre appareil",
  "ErrorReadingFromDevice": "Erreur lors de la lecture de l'information sur votre appareil",
  "AppIntro": "Contactez-nous pour parler avec un spécialiste de produit qui pourra répondre à vos questions a propos de Coveo. Ou bien, essayer une demonstration !",
  "TryDemo": "Essayer le démo",
  "ContactUs": "Contactez-nous",
  "NewToCoveo": "Qu'est-ce que Coveo?",
  "LetUsHelpGetStarted": "Laisser nous vous aidez a démarrer",
  "LikesThis": "{0} aime<pl>nt</pl> ça.",
  "CannotConnectSearchPage": "Impossible de rejoindre votre page de recherche",
  "AreYouSureDeleteFilter": "Êtes vous sur de vouloir effacer le filtre {0}avec l'expression {1}",
  "OnlineHelp": "Aide en ligne",
  "Done": "Terminé",
  "SaveFacetState": "Sauvegarder l'état de la facette",
  "ClearFacetState": "Effacer l'état de la facette",
  "DisplayingTheOnlyMessage": "Affichage du seul message dans cette conversation",
  "NoNetworkConnection": "Aucune connexion réseau",
  "UnknownConnection": "Connexion inconnue",
  "EthernetConnection": "Connexion Ethernet",
  "WiFi": "Connexion WiFi",
  "CELL": "Connexion cellulaire",
  "CELL_2G": "Connexion cellulaire 2g",
  "CELL_3G": "Connexion cellulaire 3g",
  "CELL_4G": "Connexion cellulaire 4g",
  "Relevance": "Pertinence",
  "Date": "Date",
  "Amount": "Montant",
  "QueryExceptionNoException": "Aucune exception",
  "QueryExceptionInvalidSyntax": "Syntaxe invalide",
  "QueryExceptionInvalidCustomField": "Champ personnalisé invalide",
  "QueryExceptionInvalidDate": "Date invalide",
  "QueryExceptionInvalidExactPhrase": "Phrase exacte invalide",
  "QueryExceptionInvalidDateOp": "Opérateur de date invalide",
  "QueryExceptionInvalidNear": "Fonction de proximité (PRES) invalide",
  "QueryExceptionInvalidWeightedNear": "Pondérée de la fonction de proximité invalide",
  "QueryExceptionInvalidTerm": "Terme invalide",
  "QueryExceptionTooManyTerms": "Trop de termes",
  "QueryExceptionWildcardTooGeneral": "Métacaractère trop général",
  "QueryExceptionInvalidSortField": "Champ de tri invalide",
  "QueryExceptionInvalidSmallStringOp": "Opérateur de petite chaîne invalide",
  "QueryExceptionRequestedResultsMax": "Maximum des résultats demandés",
  "QueryExceptionAggregatedMirrorDead": "Le miroir agrégé est hors-ligne",
  "QueryExceptionAggregatedMirrorQueryTimeOut": "Délai de requête du miroir agrégé dépassé",
  "QueryExceptionAggregatedMirrorInvalidBuildNumber": "Numéro de version du miroir agrégé invalide",
  "QueryExceptionAggregatedMirrorCannotConnect": "Connexion impossible au miroir agrégé",
  "QueryExceptionNotEnoughLeadingCharsWildcard": "Pas assez de caractères en début de chaîne pour le métacaractère",
  "QueryExceptionSecurityInverterNotFound": "Inverseur de sécurité introuvable",
  "QueryExceptionSecurityInverterAccessDenied": "Accès refusé à l'inverseur de sécurité",
  "QueryExceptionAggregatedMirrorCannotImpersonate": "Le miroir agrégé ne peut pas usurper l'identité",
  "QueryExceptionUnexpected": "Inattendu",
  "QueryExceptionAccessDenied": "Accès refusé",
  "QueryExceptionSuperUserTokenInvalid": "Jeton du super-utilisateur invalide",
  "QueryExceptionSuperUserTokenExpired": "Le jeton du super-utilisateur est expiré",
  "QueryExceptionLicenseQueriesExpired": "La licence de requêtes est expirée",
  "QueryExceptionLicenseSuperUserTokenNotSupported": "Licence de jeton de super utilisateur non pris en charge",
  "QueryExceptionInvalidSession": "Session invalide",
  "QueryExceptionInvalidDocument": "Document invalide",
  "QueryExceptionSearchDisabled": "Recherche désactivée",
  "FileType": "Type de fichier",
  "ShowAttachment": "Voir pièce jointe",
  "OnFeed": "sur le fil de {0}.",
  "Author": "Auteur",
  "NoTitle": "Pas de titre",
  "CurrentSelections": "Sélections courantes",
  "AllContent": "Tout le contenu",
  "CancelLastAction": "Annuler la dernière action",
  "SearchTips": "Conseils de recherche",
  "CheckSpelling": "Vérifiez l'orthographe de vos mots-clés.",
  "TryUsingFewerKeywords": "Essayez d'utiliser moins ou différents mots-clés.",
  "SelectFewerFilters": "Sélectionner moins de filtres pour élargir votre recherche.",
  "Document": "Document",
  "Time": "Temps",
  "StartDate": "Date de début",
  "StartTime": "Heure de début",
  "DurationTitle": "Durée",
  "UserQuery": "Requête de l'utilisateur",
  "ShowUserActions": "Afficher les actions de l'utilisateur",
  "NoData": "Aucune donnée disponible",
  "EventType": "Type d'évenement",
  "GoToFullSearch": "Aller à la page de recherche",
  "GoToEdition": "Personnaliser le panneau",
  "RemoveContext": "Enlever le contexte",
  "BoxAttachToCase": "Attacher à la requête",
  "AttachToCase": "Attacher à la requête",
  "Attach": "Attacher",
  "Attached": "Attaché",
  "Detach": "Détacher",
  "Details": "Détails",
  "AdditionalFilters": "Filtres additionnels",
  "SelectNonContextualSearch": "Enlevez le contexte de l'entrée courante pour élargir vos résultats de recherche",
  "CopyPasteToSupport": "Copier-coller ce message à l'équipe de support de Coveo pour plus d'informations.",
  "FollowQueryDescription": "Avertissez-moi lorsque les résultats de recherche de cette requête changent.",
  "SearchAlerts_Panel": "Gérer les alertes",
  "SearchAlerts_PanelDescription": "Afficher et gérer vos alertes de recherche.",
  "SearchAlerts_PanelNoSearchAlerts": "Vous n'avez aucun abonnement.",
  "SearchAlerts_Fail": "Le service d'alertes de recherche n'est actuellement pas disponible.",
  "SearchAlerts_Type": "Type",
  "SearchAlerts_Content": "Contenu",
  "SearchAlerts_Actions": "Action",
  "EmptyQuery": "<vide>",
  "SearchAlerts_Type_followQuery": "Requête",
  "SearchAlerts_Type_followDocument": "Item",
  "SearchAlerts_unFollowing": "Ne plus suivre",
  "SearchAlerts_follow": "Suivre",
  "SearchAlerts_followed": "Suivi",
  "SearchAlerts_followQuery": "Suivre la requête",
  "Subscription_StopFollowingQuery": "Ne plus suivre la requête",
  "SearchAlerts_Frequency": "Quand",
  "SubscriptionsManageSubscriptions": "Gérer vos alertes",
  "SubscriptionsMessageFollowQuery": "Vous recevrez des alertes lorsque la requête <b>{0}</ b> retournera des items nouveaux ou mis à jour.",
  "SubscriptionsMessageFollow": "Vous recevrez des alertes lorsque l'item <b>{0}</b> sera mis à jour.",
  "Expiration": "Expiration",
  "Monthly": "Mensuel",
  "Daily": "Quotidiennement",
  "Monday": "Lundi",
  "Tuesday": "Mardi",
  "Wednesday": "Mercredi",
  "Thursday": "Jeudi",
  "Friday": "Vendredi",
  "Saturday": "Samedi",
  "Sunday": "Dimanche",
  "NextDay": "{0} prochain",
  "LastDay": "{0} dernier",
  "StartTypingCaseForSuggestions": "Décrivez votre problème pour voir des solutions possibles",
  "ExportToExcel": "Exportez en format Excel",
  "ExportToExcelDescription": "Exportez les résultats de recherche en format Excel",
  "CaseCreationNoResults": "Aucune recommandation de solution n'a été trouvée",
  "SortBy": "Trier par",
  "BoxCreateArticle": "Créer un Article",
  "Facets": "Facettes",
  "AdvancedSearch": "Recherche Avancée",
  "Keywords": "Mot-clés",
  "AllTheseWords": "Tous ces mots",
  "ExactPhrase": "Cette phrase exacte",
  "AnyOfTheseWords": "N'importe lequel de ces mots",
  "NoneOfTheseWords": "Aucun de ces mots",
  "Anytime": "N'importe quand",
  "InTheLast": "Dans les derniers",
  "Days": "jours",
  "Months": "mois",
  "Month": "Mois",
  "Year": "Année",
  "Between": "Entre",
  "Language": "Langage",
  "Size": "Taille",
  "AtLeast": "au moins",
  "AtMost": "au plus",
  "Contains": "contient",
  "DoesNotContain": "ne contient pas",
  "Matches": "égale",
  "Bytes": "octets",
  "card": "Carte",
  "table": "Tableau",
  "ResultLinks": "Liens de résultat",
  "EnableQuerySyntax": "Activation de la syntaxe de recherche",
  "On": "Activé",
  "Off": "Désactivé",
  "Automatic": "Automatique",
  "ResultsPerPage": "Résultats par page",
  "PreviousMonth": "Mois précédent",
  "NextMonth": "Mois suivant",
  "Title": "Titre",
  "FiltersInAdvancedSearch": "Filtres pour la Recherche Avancée",
  "NoEndpoints": "{0} n'a pas de point de terminaison unique.",
  "InvalidToken": "Le jeton d'identification est invalide.",
  "AddSources": "Vous devrez ajouter des sources à votre index, ou attendre la fin de l'indexation des sources créées.",
  "TryAgain": "Veuillez essayer de nouveau.",
  "CoveoOnlineHelp": "Aide en ligne Coveo",
  "CannotAccess": "{0} est inaccessible.",
  "CoveoOrganization": "Organisation Coveo",
  "SearchAPIDuration": "Durée de l'API de recherche : {0}",
  "LastUpdated": "Dernière mise à jour",
  "AllDates": "Toutes les dates",
  "WithinLastDay": "Depuis le dernier jour",
  "WithinLastWeek": "Depuis la dernière semaine",
  "WithinLastMonth": "Depuis le dernier mois",
  "WithinLastYear": "Depuis la dernière année",
  "RelevanceInspector": "Inspecteur de Pertinence des Documents",
  "KeywordInCategory": "{0} <span class=\"coveo-omnibox-suggestion-category\">dans {1}</span>",
  "Result": "Résultat",
  "ResultCount": "{0} résultat<pl>s</pl>",
  "ShowingResults": "{0} résultat<pl>s</pl>",
  "ShowingResultsWithQuery": "{0} résultat<pl>s</pl> pour {1}",
  "NumberOfVideos": "Nombre de vidéos",
  "AllCategories": "Toutes les catégories",
  "Recommended": "Recommandé",
  "Featured": "En vedette",
  "CoveoHomePage": "Page d'accueil Coveo",
  "SizeValue": "Valeur de la taille",
  "UnitMeasurement": "Unité de taille",
  "Toggle": "Basculer",
  "FilterOn": "Filtrer sur {0}",
  "RemoveFilterOn": "Enlever le filtre d'inclusion sur {0}",
  "Enter": "Entrée",
  "InsertAQuery": "Insérer une requête",
  "PressEnterToSend": "Appuyez sur Entrée pour envoyer",
  "SortResultsBy": "Trier les résultats par {0}",
  "SortResultsByAscending": "Trier en ordre croissant de {0}",
  "SortResultsByDescending": "Trier en ordre décroissant de {0}",
  "DisplayResultsAs": "Afficher les résultats comme {0}",
  "FacetTitle": "Facette {0}",
  "IncludeValueWithResultCount": "Filtre d'inclusion sur {0}; {1}",
  "ExcludeValueWithResultCount": "Filtre d'exclusion sur {0}; {1}",
  "PageNumber": "Page {0}",
  "DisplayResultsPerPage": "Afficher {0} résultats par page",
  "GroupByAndFacetRequestsCannotCoexist": "La requête n'est pas valide car elle contient les requêtes Group By et Facet. Assurez-vous que l'interface de recherche n'initialise pas les composants DynamicFacet aux côtés des composants Facet (ou de tout composant d'extension du composant Facet, tel que FacetRange ou FacetSlider).",
  "MustContain": "Doit contenir:",
  "Missing": "Manquant(s):",
  "Filters": "Filtres",
  "FiltersDropdown": "Menu déroulant de filtres",
  "OpenFiltersDropdown": "Ouvrir le menu déroulant de filtres",
  "CloseFiltersDropdown": "Fermer le menu déroulant de filtres",
  "NoValuesFound": "Aucune valeur trouvée.",
  "To": "à",
  "DeselectFilterValues": "Effacer tout de filtres actifs dans {0}",
  "Rated": "Évalué {0} sur {1} étoile<pl>s<pl/>",
  "RatedBy": "par {0} utilisateur<pl>s</pl>",
  "NoRatings": "Aucune évaluation",
  "Pagination": "Pagination",
  "ThumbnailOf": "Aperçu de « {0} »",
  "CollapsedUriParts": "Segments d'URI réduits",
  "HierarchicalFacetValueIndentedUnder": "{0} sous {1}",
  "HierarchicalFacetValuePathPrefix": "dans",
  "UsefulnessFeedbackRequest": "Était-ce utile?",
  "UsefulnessFeedbackThankYou": "Merci pour votre rétroaction!",
  "UsefulnessFeedbackExplainWhy": "Expliquer pourquoi",
  "UsefulnessFeedbackExplainWhyImperative": "Expliquez pourquoi",
  "UsefulnessFeedbackDoesNotAnswer": "Ceci n'a pas répondu à ma question du tout",
  "UsefulnessFeedbackPartiallyAnswers": "Ceci a seulement partiellement répondu à ma question",
  "UsefulnessFeedbackWasNotAQuestion": "Ma requête n'était pas sensée être perçue comme une question",
  "Yes": "Oui",
  "No": "Non",
  "Other": "Autre",
  "Send": "Envoyer",
  "Edit": "Éditer",
  "Delete": "Supprimer",
  "Save": "Sauvegarder",
  "UsefulnessFeedbackReason": "Raison",
  "AnswerSnippet": "Réponse à votre question",
  "AnswerSpecificSnippet": "Réponse à « {0} »",
  "SuggestedQuestions": "Autres questions posées",
  "ExpandQuestionAnswer": "Regarder la réponse à « {0} »",
  "MoreValuesAvailable": "des valeurs additionnelles sont disponibles",
  "Breadcrumb": "Filtres actifs",
  "OrganizationIsPaused": "Votre organisation Coveo est en pause pour cause d'inactivité et la recherche est présentement non disponible.",
  "OrganizationWillResume": "Votre organisation redeviendra active et sera bientôt disponible.",
  "UpdatingResults": "Chargement des résultats",
  "QuerySuggestionsAvailable": "{0} suggestion<pl>s</pl> de recherche disponible.",
  "QuerySuggestionsUnavailable": "Il n'y a pas de suggestions de recherche.",
}

  var locales = String["locales"] || (String["locales"] = {});
  locales["fr"] = merge(locales["fr"], dict);
  String["toLocaleString"].call(this, { "fr": dict });
  String["locale"] = "fr";
  String["defaultLocale"] = "en";
  Globalize.culture("fr")
}